#!/bin/sh

# Set_Union.sh
# Chieh Cheng
# 2006-06-19

# Returns a new set containing the union of two sets.

# GNU General Public License (GPL), Version 2, June 1991

scriptname=`echo $0 | sed s/\\\\/.*\\\\///g`

if [ $# -ne 3 ]
then
  echo "  Usage:   $scriptname \"name 1\" \"name 2\" \"new name\""
  echo
  echo "           name 1 - Name of the first set."
  echo "           name 2 - Name of the second set."
  echo "           new name - Name of the resulting set. If it exists, it is overwritten."
  exit
fi

name1="$1"
name2="$2"
newSet="$3"

result1=`Set_Exists.sh "${name1}"`
result2=`Set_Exists.sh "${name2}"`

if [ "${result1}" == "true" -a "${result2}" == "true" ]
then
  newFile=`Set_GetFileName.sh "${newSet}"`
  Set_Show "${name1}" > /tmp/Set_Union.txt
  Set_Show "${name2}" >> /tmp/Set_Union.txt
  cat /tmp/Set_Union.txt | sort | uniq > "${newFile}"
else
  echo "${scriptname}: Set ${name1} and/or set ${name2} does not exist!."
fi
