#!/bin/sh

# Set_Export.sh
# Chieh Cheng
# 2006-06-19

# Export elements in a set to a file.

# GNU General Public License (GPL), Version 2, June 1991

scriptname=`echo $0 | sed s/\\\\/.*\\\\///g`

if [ $# -ne 2 ]
then
  echo "  Usage:   $scriptname \"name\" \"file\""
  echo
  echo "           name - Name of the set to export."
  echo "           file - The export file name."
  exit
fi

name="$1"
file="$2"

result=`Set_Exists.sh "${name}"`

if [ "$result" == "true" ]
then
  setFile=`Set_GetFileName.sh "${name}"`
  cp "${setFile}" "${file}"
else
  echo "${scriptname}: Set ${name} does not exist!"
fi
